## test the toroidal features.

xmin <- 10; xmax <- 40; ymin <- 20; ymax <- 30
wid <- xmax - xmin; ht <- ymax - ymin

dyn.unload("../src/sjedmin.so")
dyn.load("../src/sjedmin.so")


t1 <- function(tor, x0, y0, x1, y1, wid, ht) {
  z <- .C("dist2d_tor_R",
          as.integer(tor),
          as.double(x0), as.double(y0),
          as.double(x1), as.double(y1),
          as.double(wid), as.double(ht),
          ## return value.
          res=double(1),
          PACKAGE="sjedmin")
  z$res
}



show.plot <- function(x0, y0, x1, y1) {

  d0 <- t1( 0, x0, y0, x1, y1, wid, ht)
  d1 <- t1( 1, x0, y0, x1, y1, wid, ht)
  
  plot( rbind( c(x0, y0), c(x1, y1)), xlim=c(xmin, xmax),
       ylim=c(ymin, ymax), asp=1)
  title(sprintf("pts %.0f, %.0f  %.0f, %.0f dist0 %.2f dist1 %.2f ", x0, y0,
                x1, y1, d0, d1))
  rect(xmin, ymin, xmax, ymax, lty=2)
}


postscript(file="test_tor.ps", wid=10, height=6)
par(mfrow=c(4,2), mar=c(2,2,2.3, 0.3))
show.plot(12, 21, 38, 24)
show.plot(12, 25, 38, 24)
show.plot(12, 22, 38, 24)
show.plot(25, 22, 38, 24)
show.plot(35, 22, 38, 24)
show.plot(38, 22, 38, 24)
show.plot(38, 29, 38, 23)
show.plot(34, 29, 33, 22)
show.plot(10, 29, 34, 29)
show.plot(11, 21, 38, 28)
show.plot(11, 28, 38, 21)
dev.off()


py <- function(dx, dy) { sqrt( (dx*dx) + (dy*dy))}
py(13, 2)


library(sjedmin)
w <- c(200, 1500, 300, 1000)
npts <- 100


x.lut <- seq(from=30, to=160, by=10)
y.lut <- ifelse(x.lut > 70, 1, 0)

plot(x.lut, y.lut, pch=19, col='red', type='p')
lines(x, sapply(x, function(d) {hlookup(y.lut, x.lut, d)}), col='red')


postscript(file="tor_test.ps")
for (tor in c(FALSE, TRUE)) {
  p <- pipp.lookup(w=w, n1=npts, pts=NULL,
                   h=y.lut, d=x.lut, nsweeps=10, verbose=F, tor=tor)

  
}
dev.off()

