### Name: sjedmin
### Title: Dmin mosaics
### Aliases: dminl dminlul plot.sjedmin
### Keywords: spatial

### ** Examples

wid <- 500; ht <- 500; ncells <- 400; dmin.mean <- 20; dmin.sd <- 4
dmin.lower <- 12; dmin.higher <- 28
w <- c( 100, 100+wid, 200, 200+ht)
par(mfcol=c(3,3))
d1 <- dminl(wid, ht, ncells, dmin.mean, dmin.sd)
plot(d1)
plot(d1$nrejects, main="rejects increase as function of cells placed",
xlab="cell number", ylab="# rejects")
hist(d1$dmins)
d2 <- dminlul(w, ncells, dmin.mean, dmin.sd, dmin.lower,dmin.higher)
plot(d2)
plot(d2$nrejects, xlab="cell number", ylab="# rejects")
hist(d2$dmins)
d3 <- dminlul(w+2000, ncells, dmin.mean, dmin.sd, dmin.lower,-1)
plot(d3)
plot(d3$nrejects, xlab="cell number", ylab="# rejects")
hist(d3$dmins)

## Generate dmin taking into consideration a set of cells already in the layer.
par(mfrow=c(1,1))
r1 <- 12; r2 <- 50 ## radii of cells
d <- dminlulfix2(dmin=2*r1, dminsd=0.01, d12=r1+r2, npts=800,
                 w=c(150, 900, 200, 1200),
                 p2=matrix(c (200,500, 800, 750, 700,500, 500, 1000),ncol=2))
plot(d, r1=r1, r2=r2)

r1 <- 8; r2 <- 50;  d12 <- r1+r2; dmin <- r1*2
p2 <- matrix(c (200, 500, 630, 400,    700, 500, 800, 760),ncol=2)
d <- dminlulfix2(w = c( 100, 800, 400, 900),
                 npts = 700,
                 dmin = dmin, dminsd = 0.0001,
                 lower=12, upper=-1, d12=d12, p2=p2)
plot(d, r1=r1, r2=r2)

## Bivariate simulation.
plot(bdmin.bd(n1=50, n2=30, d1=50, d2=30, d12=80, nsweeps=20))



