
## ----install-sjemea,eval=FALSE,echo=TRUE---------------------------------
## install.packages(c("sjemea"), contriburl="http://damtp.cam.ac.uk/user/eglen/r/")
## vignette('sjemea-intro', package='sjemea')


## ----setup,message=FALSE-------------------------------------------------
require(sjemea)
require(knitr)
opts_chunk$set(cache=TRUE)
opts_chunk$set(dev='pdf')


## ----help----------------------------------------------------------------
help(package=sjemea)


## ------------------------------------------------------------------------
data.file <- system.file("examples", "P9_CTRL_MY1_1A.txt",
                         package = "sjemea")
s <- jay.read.spikes( data.file)
fourplot(s)


## ----bursts--------------------------------------------------------------
data.file <- system.file("examples", "TC89_DIV15_A.nexTimestamps",
package = "sjemea")
s <- sanger.read.spikes(data.file)
s$allb <- spikes.to.bursts.surprise(s)


## ----show-burst-info-----------------------------------------------------
head(s$allb[[2]])
nbursts <- sapply(s$allb, nrow)
plot(nbursts, xlab='Electrode number', ylab='Number of bursts',
     bty='n', las=1)


## ----burst-raster--------------------------------------------------------
plot(s, beg=100, end=200, show.bursts=TRUE, whichcells=1:5)


## ------------------------------------------------------------------------
example(compute.ns)


## ------------------------------------------------------------------------
jay.data.file <- system.file("examples", "P9_CTRL_MY1_1A.txt",
                         package = "sjemea")
jay.s <- jay.read.spikes( jay.data.file)
plot.corr.index(jay.s)



## ----eval=FALSE,include=TRUE---------------------------------------------
## require(knitr); knit2pdf('sjemea-intro.Rnw')


