### R code from vignette source 'hlookup.Rnw'

###################################################
### code chunk number 1: hlookup.Rnw:42-43
###################################################
library(sjedmin)


###################################################
### code chunk number 2: hlookup.Rnw:57-65
###################################################
h <- function(d) {
  ifelse(d>20, 1, 0)
}

d <- seq(from=6, to=30, by=2)

h1 <- h(d)
print(lut1 <- rbind(d, h1))


###################################################
### code chunk number 3: hlookup.Rnw:73-74
###################################################
hlookup(h1, d, 21)


###################################################
### code chunk number 4: hlookup.Rnw:83-103
###################################################
hpar <- function(d,theta) {
  ## Choice of h() suggested by Peter.
  delta<-theta[1]
  sigma<-theta[2]
  kappa<-theta[3]
  res <- (0*(d<delta)) + (d>=delta)*(1-exp(-((d-delta)/sigma)^kappa))
  if (any (is.nan(res)))
    res[ which(is.nan(res))] <- 0

  res
}

theta <- c(35, 70, 4)

x <- seq(from=0, to=200, by=1)          #just used for plotting purposes.
plot(x, hpar(x, theta), type='l')
x.lut <- seq(from=30, to=160, by=10)
y.lut <- hpar(x.lut, theta)
points(x.lut, y.lut, pch=19, col='red')
lines(x, sapply(x, function(d) {hlookup(y.lut, x.lut, d)}), col='red')


###################################################
### code chunk number 5: hlookup.Rnw:133-137
###################################################
w <- c(200, 1500, 300, 1000)
npts <- 100
p <- pipp.lookup(w=w, n1=npts, pts=NULL,
                 h=y.lut, d=x.lut, nsweeps=10, verbose=F)


###################################################
### code chunk number 6: hlookup.Rnw:140-141
###################################################
plot(p)


###################################################
### code chunk number 7: hlookup.Rnw:146-150
###################################################
p <- pipp.lookup(w=w, n1=npts, pts=NULL,
                 h=hpar(x.lut, theta=c(35, 50, 1)), 
                 d=x.lut, nsweeps=10, verbose=F)
plot(p)


###################################################
### code chunk number 8: hlookup.Rnw:176-199
###################################################
library(spatstat)
data(amacrine)
amac.on <- unmark(amacrine[amacrine$marks == "on"])
rs <- seq(from=0.025, by=0.025, length=10)

qs <- quadscheme(amac.on, method="grid", ntile=c(40,30))
x <- ppm(qs, ~1, PairPiece(r = rs), correction="isotropic")

## Now get the LUT entries.
## 2013-05-22, in future versions of spatstat, should do:
## h <- exp(coef(fitin(x))); see email from Adrian.  (Version 1.31-3 of spatsat)
h <- summary(x,quick=TRUE)$interaction$printable
if (any(is.na(h)))
  h[which(is.na(h))] <- 0

x <- apply(rbind(rs, c(0, rs[1:(length(rs)-1)])), 2, mean)


## Now simulate using (x,h) as a LUT.
p <- pipp.lookup(n1=amac.on$n, pts=NULL,
                 w=c(amac.on$window$xrange, amac.on$window$yrange),
                 h=h, d=x,nsweeps=10, verbose=F)



###################################################
### code chunk number 9: hlookup.Rnw:202-206
###################################################
par(mfrow=c(2,2))
plot(amac.on)
plot(x, h, main='non par estimate of h() for amac.on', type='l')
plot(p, main='sim of amac.on from pipp.lookup')


###################################################
### code chunk number 10: hlookup.Rnw:218-243
###################################################
w <- c(0, 1000, 0, 1000)
n1 <- 100; n2 <- 100
h11.x <- seq(from=0, to=150, by=10)
h11.y <- pnorm(h11.x, mean=90, sd=20)

h22.x <- seq(from=0, to=150, by=10)
h22.y <- pnorm(h11.x, mean=70, sd=10)

h12.x <- seq(from=0, to=30, by=2)
h12.y <- pnorm(h12.x, mean=20, sd=1)

par(mfrow=c(1,2))
plot(h11.x, h11.y, type='l', col='green')
lines(h22.x, h22.y, col='orangered')
lines(h12.x, h12.y, col='black')
legend(100, .2, c(expression(h[11]), expression(h[22]), expression(h[12])),
       text.col= c("green", "red", "black"))


p <- pipp2.lookup(w=w, pts1=NULL, pts2=NULL, n1=n1, n2=n2,
                  h1=h11.y, d1=h11.x,
                  h2=h22.y, d2=h22.x,
                  h12=h12.y, d12=h12.x,
                  nsweeps=10, verbose=FALSE)
plot(p)


###################################################
### code chunk number 11: hlookup.Rnw:248-271
###################################################
par(mfrow=c(1,2))
h11.x <- seq(from=0, to=150, by=10)
h11.y <- pnorm(h11.x, mean=60, sd=20)

h22.x <- seq(from=0, to=150, by=10)
h22.y <- pnorm(h11.x, mean=60, sd=10)

h12.x <- seq(from=20, to=100, by=2)
h12.y <- pnorm(h12.x, mean=80, sd=1)

plot(h11.x, h11.y, type='l', col='green')
lines(h22.x, h22.y, col='orangered')
lines(h12.x, h12.y, col='black')
legend(0, 1, c(expression(h[11]), expression(h[22]), expression(h[12])),
       text.col= c("green", "red", "black"))

p <- pipp2.lookup(w=w, pts1=NULL, pts2=NULL, n1=n1, n2=n2,
                  h1=h11.y, d1=h11.x,
                  h2=h22.y, d2=h22.x,
                  h12=h12.y, d12=h12.x,
                  nsweeps=10, verbose=FALSE)
plot(p)



###################################################
### code chunk number 12: hlookup.Rnw:288-326
###################################################
w <- c(200, 1500, 300, 1000)
npts <- 100


x.lut <- seq(from=30, to=160, by=10)
y.lut <- ifelse(x.lut > 70, 1, 0)

##plot(x.lut, y.lut, pch=19, col='red', type='p')
##lines(x, sapply(x, function(d) {hlookup(y.lut, x.lut, d)}), col='red')

par(mfrow=c(2,1), mar=c(3,2,3,1))
for (tor in c(FALSE, TRUE)) {
  p <- pipp.lookup(w=w, n1=npts, pts=NULL,
                   h=y.lut, d=x.lut, nsweeps=10, verbose=F, tor=tor)

  x0 <- p$x; y0 <- p$y
  wid <- w[2] - w[1]
  ht <- w[4] - w[3]
  all <- rbind(cbind(x0-wid, y0+ht),
               cbind(x0,     y0+ht),
               cbind(x0+wid, y0+ht),
               cbind(x0-wid, y0),
               cbind(x0,     y0),
               cbind(x0+wid, y0),
               cbind(x0-wid, y0-ht),
               cbind(x0,     y0-ht),
               cbind(x0+wid, y0-ht)
               )
  
  dw <- wid * .2
  dh <- ht * .2
  plot(all, xlim=c(w[1] - dw, w[2] + dw), ylim=c(w[3] - dh, w[4] + dh),
       pch=19, cex=0.4, asp=1)
  title(main=paste("tor ", tor))
  rect(w[1], w[3], w[2], w[4], lty=2)
  
}
par(mfrow=c(1,1))


###################################################
### code chunk number 13: hlookup.Rnw:337-381
###################################################


r1 <- r2 <- 100                         #diameter of exclusion zones.

example.tor2 <- function(tor) {
  w <- c(0, 1000, 200, 1500)
  n1 <- n2 <- 75
  h11.x <- seq(from=0, to=150, by=10)
  h11.y <- ifelse(h11.x>r1, 1, 0)
  
  h22.x <- seq(from=0, to=150, by=10)
  h22.y <- ifelse(h22.x>r2, 1, 0)
  
  h12.x <- seq(from=0, to=60, by=2)
  h12.y <- pnorm(h12.x, mean=40, sd=1)
  
  p <- pipp2.lookup(w=w, pts1=NULL, pts2=NULL, n1=n1, n2=n2,
                    h1=h11.y, d1=h11.x,
                    h2=h22.y, d2=h22.x,
                    h12=h12.y, d12=h12.x,
                    nsweeps=10, verbose=FALSE,tor=tor)
  x0 <- p$x; y0 <- p$y
  wid <- w[2] - w[1]; ht <- w[4] - w[3]
  all <- rbind(cbind(x0-wid, y0+ht),
               cbind(x0,     y0+ht),
               cbind(x0+wid, y0+ht),
               cbind(x0-wid, y0),
               cbind(x0,     y0),
               cbind(x0+wid, y0),
               cbind(x0-wid, y0-ht),
               cbind(x0,     y0-ht),
               cbind(x0+wid, y0-ht)
               )
  
  dw <- wid * .2
  dh <- ht * .2
  cols <- c(rep("green", p$n1), rep("orangered", p$n2))
  plot(all, xlim=c(w[1] - dw, w[2] + dw), ylim=c(w[3] - dh, w[4] + dh),
       asp=1, col=cols, pch=19,cex=0.4)
  title(main=paste("tor ", tor))
  rect(w[1], w[3], w[2], w[4], lty=2)
  symbols(x0, y0, circles=rep(r1/2, n1+n2), inch=FALSE, add=TRUE, fg=cols)
}



###################################################
### code chunk number 14: hlookup.Rnw:387-388
###################################################
example.tor2(tor=FALSE)


###################################################
### code chunk number 15: hlookup.Rnw:391-392
###################################################
example.tor2(tor=TRUE)


