/*
 * The author of this software is Steven Fortune.  Copyright (c) 1994 by AT&T
 * Bell Laboratories.
 * Permission to use, copy, modify, and distribute this software for any
 * purpose without fee is hereby granted, provided that this entire notice
 * is included in all copies of any software which is or includes a copy
 * or modification of this software and in all copies of the supporting
 * documentation for such software.
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR AT&T MAKE ANY
 * REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY
 * OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */
#
#include <stdio.h>
#include "defs.h"
struct Site *readone();
struct Site *nextone();

int triangulate, sorted, plot, debug;
struct	Site	*sites;
int		nsites;
int		siteidx;
struct 	Freelist sfl;

extern Sfloat xmin, xmax, ymin, ymax, deltax, deltay;
#ifdef NEED_MAIN_ROUTINE
main(argc,argv) 
     char **argv; 
     int argc;
{	
  int c;
  struct Site *(*next)();

  sorted = 0; triangulate = 0; plot = 0; debug = 0;
  while((c=getopt(argc,argv,"dpst")) != EOF)
    switch(c) {
    case 'd': debug = 1;
      break;
    case 's': sorted = 1;
      break;
    case 't': triangulate = 1;
      break;
    case 'p': plot = 1;
      break;
    };

  freeinit(&sfl, sizeof *sites);
  if(sorted)
    {	scanf("%d %f %f %f %f", &nsites, &xmin, &xmax, &ymin, &ymax);
    next = readone;
    }
  else 
    {	readsites();
    next = nextone;
    };

  siteidx = 0;
  geominit();
  if(plot) plotinit();

  voronoi(triangulate, next); 

}
#endif


/* sort sites on y, then x, coord */
int scomp(s1,s2)
     struct Point *s1,*s2;
{
  if(s1 -> y < s2 -> y) return(-1);
  if(s1 -> y > s2 -> y) return(1);
  if(s1 -> x < s2 -> x) return(-1);
  if(s1 -> x > s2 -> x) return(1);
  return(0);
}

/* return a single in-storage site */
struct Site *nextone()
{
  struct Site *s;

  /*printf("sje: nextone\n");*/
  if(siteidx < nsites)
    {	s = &sites[siteidx];
    siteidx += 1;
    return(s);
    }
  else	return( (struct Site *)NULL);
}


/* read all sites, sort, and compute xmin, xmax, ymin, ymax */
readsites()
{
  int i;

  nsites=0;
  sites = (struct Site *) myalloc(4000*sizeof *sites);
  while(scanf("%f %f", &sites[nsites].coord.x, &sites[nsites].coord.y)!=EOF)
    {	sites[nsites].sitenbr = nsites;
    sites[nsites].refcnt = 0;
    nsites += 1;
    if (nsites % 4000 == 0) 
      sites = (struct Site *) realloc(sites,(nsites+4000)*sizeof*sites);
    };
  qsort(sites, nsites, sizeof *sites, scomp);
  xmin=sites[0].coord.x; 
  xmax=sites[0].coord.x;
  for(i=1; i<nsites; i+=1)
    {	if(sites[i].coord.x < xmin) xmin = sites[i].coord.x;
    if(sites[i].coord.x > xmax) xmax = sites[i].coord.x;
    };
  ymin = sites[0].coord.y;
  ymax = sites[nsites-1].coord.y;
}


/* read all sites, sort, and compute xmin, xmax, ymin, ymax */
void sje_readsites(Sfloat *xpts, Sfloat *ypts, int npts)
{
  int i;
  int pt;
  nsites=0;
  sites = (struct Site *) myalloc(4000*sizeof *sites);

  for(pt=0; pt < npts; pt++) {
    sites[nsites].coord.x = xpts[pt];
    sites[nsites].coord.y = ypts[pt];
    
    sites[nsites].sitenbr = nsites;
    sites[nsites].refcnt = 0;
    nsites += 1;
    if (nsites % 4000 == 0) 
      sites = (struct Site *) S_realloc(sites,(nsites+4000), nsites,
					sizeof*sites);
					
					
  };

  
  qsort(sites, nsites, sizeof *sites, scomp);
  xmin=sites[0].coord.x; 
  xmax=sites[0].coord.x;
  for(i=1; i<nsites; i+=1)
    {	if(sites[i].coord.x < xmin) xmin = sites[i].coord.x;
    if(sites[i].coord.x > xmax) xmax = sites[i].coord.x;
    };
  ymin = sites[0].coord.y;
  ymax = sites[nsites-1].coord.y;
}

/* read one site */
struct Site *readone()
{
  struct Site *s;

  s = (struct Site *) getfree(&sfl);
  s -> refcnt = 0;
  s -> sitenbr = siteidx;
  siteidx += 1;
  if(scanf("%f %f", &(s->coord.x), &(s->coord.y)) == EOF)
    return ((struct Site *) NULL );
  return(s);
}
