%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CHIP geometry
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fprintf(1, '\n === START: generate geometry ====\n\n');

clear;

inputdir  = 'd_geom/setup_002/';
outputdir = 'd_geom/setup_002/';



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% obstacles
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

obstacles = 15;% setup_001
obstacles = 1; % setup_000
obstacles = 22;% setup_002

obs     = zeros(7, 2, obstacles);
s_obs   = zeros(7, 2, obstacles);

d     = 1; %chlamy diameter (10 mu)



% Vasily
angle = 30*pi/180;
arm   = 11.4 * d;
gap   = 2 * d;

% Optimal
V=10;
mu=1;
theta=0.3;
angle = 0.5*(0.5*pi - theta);
arm = V * mu * d * cos(theta+angle) * tan(angle) 
gap = V * mu * d * sin(theta) * sec(angle) 

shift = gap + 2 * arm * sin(angle);

for i=1:obstacles
 
 base_x = 0;
 base_y = (i-1) * shift;
 top_x  = base_x + arm * cos(angle) ;
 top_y  = base_y + arm * sin(angle) ;
 bottom_x  = base_x + arm * cos(angle) ;
 bottom_y  = base_y - arm * sin(angle) ;
 
 obs(1, 1, i) = base_x - 0.5 * d / sin(angle);
 obs(1, 2, i) = base_y ;

 obs(2, 1, i) = top_x ;
 obs(2, 2, i) = top_y + 0.5 * d / cos(angle);
 
 obs(3, 1, i) = top_x ;
 obs(3, 2, i) = top_y - 0.5 * d / cos(angle);
 
 
 obs(4, 1, i) = base_x + 0.5 * d/sin(angle);
 obs(4, 2, i) = base_y ;
 
 obs(5, 1, i) = bottom_x ;
 obs(5, 2, i) = bottom_y + 0.5 * d / cos(angle);
 
 obs(6, 1, i) = bottom_x ;
 obs(6, 2, i) = bottom_y - 0.5 * d / cos(angle);
 
 obs(7, 1, i) = obs(1, 1, i) ;
 obs(7, 2, i) = obs(1, 2, i) ;

end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% shift obstacles so that center at zero
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

s_obs = obs;

s_obs(:,1,:) = s_obs(:,1,:) - (obs(2, 1, 1)- obs(1, 1, 1))/2;
s_obs(:,2,:) = s_obs(:,2,:) - (obs(1, 2, obstacles)- obs(1, 2, 1))/2;

s_obs;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% more obstacles
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

rows = 1; % setup_000
rows = 4; % setup_001, setup_002

Ly = obs(2, 2, obstacles) - obs(6, 2, 1) + gap;
Lx = (1+rows)*Ly;


row_shift = Ly;

row_obs   = zeros(7, 2, obstacles, rows);

for r=1:rows;
    row_obs(:,1,:,r) = s_obs(:,1,:) + (r-1) * row_shift;
    row_obs(:,2,:,r) = s_obs(:,2,:);
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% corners
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

corners = 4;


filestub = 'corners';

corn = zeros(corners+1,2);

corn(1,1) = -Lx/2;
corn(1,2) = -Ly/2;

corn(2,1) = Lx/2;
corn(2,2) = -Ly/2;

corn(3,1) = Lx/2;
corn(3,2) = Ly/2;

corn(4,1) = -Lx/2;
corn(4,2) = Ly/2;

corn(5,1) = corn(1,1);
corn(5,2) = corn(1,2);

corn;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% shift everything so that so that lower left corner at zero
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

corn(:,1) = corn(:,1)- corn(1,1);
corn(:,2) = corn(:,2)- corn(1,2);


row_obs(:,1,:,:) = row_obs(:,1,:,:) + row_shift, 
row_obs(:,2,:,:) = row_obs(:,2,:,:) + Ly/2;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% plot
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close(figure(1))
figure(1)
axis equal;

line(corn(:,1), corn(:,2))


for i=1:obstacles
    for r=1:rows
        line(row_obs(:,1,i,r), row_obs(:,2,i,r))
    end
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% export geometry
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fprintf(1, 'export geometry \n');
savefile = [outputdir, 'obstacles.mat'];
save(savefile, 'row_obs');
clear('row_obs');

savefile = [outputdir, 'boundary.mat'];
save(savefile, 'corn');
clear('corn');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% re-import geometry
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fprintf(1, 'TEST: re-import geometry \n');
loadfile = [inputdir, 'obstacles.mat'];
load(loadfile, 'row_obs');

loadfile = [inputdir, 'boundary.mat'];
load(loadfile, 'corn');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% re-plot
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close(figure(2))
figure(2)
axis equal;

line(corn(:,1), corn(:,2))


for i=1:obstacles
    for r=1:rows
        line(row_obs(:,1,i,r), row_obs(:,2,i,r))
    end
end


clear;

fprintf(1, '\n=== done ===\n\n');

%%%%%
% d    = 10 mu
% Ly   =  2 mm
% Lx   =  10 mm / 4 obstacle rows
% fill = 0.01
% N    =2000
% 10 min