function  coll_time = f_coll_time(r1, r2, v1, v2, b1, b2, c1, c2 )
%  F_COLL_TIME computes collision time line segment
%  (r1,r2) and (v1,v2) are particle position & velcoity
%  (b1,b2) and (c1,c2) are boundary initial & end point

denom = (b2 - c2) * v1 - (b1 - c1) * v2; %eps_ij
num_t = (c1 - r1) * b2 + (r1 - b1) * c2 + (b1 - c1) * r2;
num_l = (b2 - r2) * v1 - (b1 - r1) * v2;

tc =  num_t / denom;
lc =  num_l / denom;

if tc>0 && lc>0 && lc<1
     %fprintf(1, ' collision possible\n');
     coll_time = tc;
else
     %fprintf(1, ' collision NOT possible\n');
     coll_time = Inf;
end

end

