%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ANOMALOUS diffusion test
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fprintf(1, '\n === START: particle dynamics ====\n\n');

clear all;
%close all hidden;

inputdir  = 'd_diff/001/';
outputdir = 'd_diff/001/';


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% particle seeding
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fprintf(1, 'Generate initial conditions \n\n');

rand('twister',5489);

N=1e5; % number of particles

mu=1; %sec
tumbles = 100;

phi_max = 0.25*pi;
phi_min = -phi_max;

% initial conditions
Time = zeros(N,1);
Pos  = zeros(N,2);
Vel  = zeros(N,2);
v_phi= zeros(N,1);

msd  = zeros(N, tumbles, 2);

v_phi= random('unif', phi_min, phi_max, [N, 1] );
Vel(:,1) = cos(v_phi);
Vel(:,2) = sin(v_phi);

for t=1:tumbles
    
    % update time
    tum  = exprnd(mu, [N, 1]);
    Time = Time + tum;
    
    % update positions
    Pos(:,1) = Pos(:,1)  + Vel(:,1)  .* tum;
    Pos(:,2) = Pos(:,2)  + Vel(:,2)  .* tum;
    
    % new velocity
    v_phi= v_phi + random('unif', phi_min, phi_max, [N, 1] );
    Vel(:,1) = cos(v_phi);
    Vel(:,2) = sin(v_phi);
    
    msd(:, t, 1)=    Time;
    msd(:, t, 2)=    Pos(:,1).* Pos(:,1) +  Pos(:,2).* Pos(:,2);
    
    
     if mod(t,10)==0
         fprintf(1, '\n tumble = %g',t);
     end
end

total =prod(size(msd(:, :, 1)));

msd_all = zeros(total,2);

msd_all(:,1)= reshape(msd(:, :, 1), total, 1 );
msd_all(:,2)= reshape(msd(:, :, 2), total, 1 );

%s_msd_all= sortrows(msd_all, 1);

% figure(1);
% plot(msd_all(:,1), msd_all(:,2), 'o');
% 
% figure(2);
% plot(s_msd_all(:,1), s_msd_all(:,2), 'o');


list = msd_all;

s_list = sortrows(list, 1);
[rows, cols] = size(s_list);

bins =1000;
binwidth= round(rows / bins);

for b = 1: (bins - 2)
    s_list_mean(b, 1) =  mean( s_list(  (b-1)* binwidth + 1 : b * binwidth + 1, 1 ) );
    s_list_mean(b, 2) =  mean( s_list(  (b-1)* binwidth + 1 : b * binwidth + 1, 2 ) );
end

figure(3);
hold on;
loglog(s_list_mean(:,1), s_list_mean(:,2)./s_list_mean(:,1), 'og');
xlim(gca,[0.1 100]);
ylim(gca,[0.1 100]);

saveas(figure(3), [outputdir,'P_sf_02.png'], 'png');

      
fprintf(1, '\n\n done \n\n');




