%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CHIP geometry: SIMPLE obstacles
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fprintf(1, '\n === START: generate geometry ====\n\n');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% get parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

extra_obs=0;

inputdir  = w_inputdir;
outputdir = w_outputdir
angle     = w_angle;
arm       = w_arm;
gap       = w_gap;


eff_obstacle_thickness = 2*d;

shift =  w_shift; % vertical shift of obstacles

obstacles =  w_obstacles_per_row;
rows      =  w_obstacle_rows;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% wedge obstacles
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

obs     = zeros(7, 2, obstacles);
s_obs   = zeros(7, 2, obstacles);

%%% shape 3

for i=1:obstacles
    
    base_x = 0;
    base_y = (i-1) * shift;
    top_x  = base_x + arm * cos(angle) ;
    top_y  = base_y + arm * sin(angle) ;
    bottom_x  = base_x + arm * cos(angle) ;
    bottom_y  = base_y - arm * sin(angle) ;
    
    
    obs(1, 1, i) = base_x - 0.5* eff_obstacle_thickness / tan(angle);
    obs(1, 2, i) = base_y ;
    
    obs(2, 1, i) = top_x ;
    obs(2, 2, i) = top_y + 0.5*eff_obstacle_thickness ;
    
    obs(3, 1, i) = top_x ;
    obs(3, 2, i) = top_y - 0.5*eff_obstacle_thickness;
    
    
    obs(4, 1, i) = base_x + 0.5*eff_obstacle_thickness / tan(angle) ;
    obs(4, 2, i) = base_y ;
    
    obs(5, 1, i) = bottom_x ;
    obs(5, 2, i) = bottom_y + 0.5*eff_obstacle_thickness;
    
    obs(6, 1, i) = bottom_x ;
    obs(6, 2, i) = bottom_y - 0.5*eff_obstacle_thickness;
    
    obs(7, 1, i) = obs(1, 1, i) ;
    obs(7, 2, i) = obs(1, 2, i) ;
    
end

%%% shape 2

% for i=1:obstacles
%     
%     base_x = 0;
%     base_y = (i-1) * shift;
%     top_x  = base_x + arm * cos(angle) ;
%     top_y  = base_y + arm * sin(angle) ;
%     bottom_x  = base_x + arm * cos(angle) ;
%     bottom_y  = base_y - arm * sin(angle) ;
%     
%     
%     obs(1, 1, i) = base_x - 0.5*eff_obstacle_thickness / sin(angle);
%     obs(1, 2, i) = base_y ;
%     
%     obs(2, 1, i) = top_x + 0.5* ( d * cos(angle) - eff_obstacle_thickness * sin(angle));
%     obs(2, 2, i) = top_y + 0.5* ( d * sin(angle) + eff_obstacle_thickness * cos(angle));
%     
%     obs(3, 1, i) = top_x + 0.5* ( d * cos(angle) + eff_obstacle_thickness * sin(angle)) ;
%     obs(3, 2, i) = top_y + 0.5* ( d * sin(angle) - eff_obstacle_thickness * cos(angle));
%     
%     
%     obs(4, 1, i) = base_x + 0.5* eff_obstacle_thickness /sin(angle);
%     obs(4, 2, i) = base_y ;
%     
%     obs(5, 1, i) = bottom_x + 0.5* ( d * cos(angle) + eff_obstacle_thickness * sin(angle)); 
%     obs(5, 2, i) = bottom_y + 0.5* (- d * sin(angle) + eff_obstacle_thickness * cos(angle));
%     
%     obs(6, 1, i) = bottom_x +0.5* ( d * cos(angle) - eff_obstacle_thickness * sin(angle));
%     obs(6, 2, i) = bottom_y + 0.5* (-d * sin(angle) - eff_obstacle_thickness * cos(angle));
%     
%     obs(7, 1, i) = obs(1, 1, i) ;
%     obs(7, 2, i) = obs(1, 2, i) ;
%     
% end


%%% shape 1

% for i=1:obstacles
%     
%     base_x = 0;
%     base_y = (i-1) * shift;
%     top_x  = base_x + arm * cos(angle) ;
%     top_y  = base_y + arm * sin(angle) ;
%     bottom_x  = base_x + arm * cos(angle) ;
%     bottom_y  = base_y - arm * sin(angle) ;
%     
%     
%     obs(1, 1, i) = base_x - eff_obstacle_thickness / sin(angle);
%     obs(1, 2, i) = base_y ;
%     
%     obs(2, 1, i) = top_x ;
%     obs(2, 2, i) = top_y + eff_obstacle_thickness  / cos(angle);
%     
%     obs(3, 1, i) = top_x ;
%     obs(3, 2, i) = top_y - eff_obstacle_thickness  / cos(angle);
%     
%     
%     obs(4, 1, i) = base_x + eff_obstacle_thickness /sin(angle);
%     obs(4, 2, i) = base_y ;
%     
%     obs(5, 1, i) = bottom_x ;
%     obs(5, 2, i) = bottom_y + eff_obstacle_thickness / cos(angle);
%     
%     obs(6, 1, i) = bottom_x ;
%     obs(6, 2, i) = bottom_y - eff_obstacle_thickness / cos(angle);
%     
%     obs(7, 1, i) = obs(1, 1, i) ;
%     obs(7, 2, i) = obs(1, 2, i) ;
%     
% end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% shift obstacles so that center at zero
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

s_obs = obs;

s_obs(:,1,:) = s_obs(:,1,:) - (obs(2, 1, 1)- obs(1, 1, 1))/2;
s_obs(:,2,:) = s_obs(:,2,:) - (obs(1, 2, obstacles)- obs(1, 2, 1))/2;

s_obs;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% more obstacles
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Ly = obs(2, 2, obstacles) - obs(6, 2, 1) + d;
Lx = (1+rows)*Ly/2;


row_shift = Ly/2;

row_obs   = zeros(7, 2, obstacles, rows);

for r=1:rows;
    row_obs(:,1,:,r) = s_obs(:,1,:) + (r-1) * row_shift;
    row_obs(:,2,:,r) = s_obs(:,2,:);
end




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% corners of box
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

corners = 4;


filestub = 'corners';

corn = zeros(corners+1,2);

corn(1,1) = -Lx/2;
corn(1,2) = -Ly/2;

corn(2,1) = Lx/2;
corn(2,2) = -Ly/2;

corn(3,1) = Lx/2;
corn(3,2) = Ly/2;

corn(4,1) = -Lx/2;
corn(4,2) = Ly/2;

corn(5,1) = corn(1,1);
corn(5,2) = corn(1,2);

corn;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% shift everything so that so that lower left corner at zero
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

corn(:,1) = corn(:,1)- corn(1,1);
corn(:,2) = corn(:,2)- corn(1,2);


row_obs(:,1,:,:) = row_obs(:,1,:,:) + row_shift;
row_obs(:,2,:,:) = row_obs(:,2,:,:) + Ly/2;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% plot
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close(figure(1))
figure(1)
axis equal;

line(corn(:,1), corn(:,2))


for i=1:obstacles
    for r=1:rows
        line(row_obs(:,1,i,r), row_obs(:,2,i,r));
    end
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% export geometry
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fprintf(1, 'export geometry \n');
savefile = [outputdir, 'obstacles.mat'];
save(savefile, 'row_obs');
clear('row_obs');

savefile = [outputdir, 'boundary.mat'];
save(savefile, 'corn');
clear('corn');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% re-import geometry
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fprintf(1, 'TEST: re-import geometry \n');
loadfile = [inputdir, 'obstacles.mat'];
load(loadfile, 'row_obs');

loadfile = [inputdir, 'boundary.mat'];
load(loadfile, 'corn');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% re-plot
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close(figure(2))
figure(2)
axis equal;

line(corn(:,1), corn(:,2));


for i=1:obstacles
    for r=1:rows
        line(row_obs(:,1,i,r), row_obs(:,2,i,r));
    end
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% extra bar-like obstacles
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if extra_obs == 1;
    
    h_length = 7*d; % in chlamy diameter
    v_length = 2*d;
    
    h_shift =  0*d;
    
    [opoints, odim, obs_per_row, rows] = size(row_obs);
    
    extra_row_obs = zeros( 5, odim, obs_per_row -1, rows );
    
    if obs_per_row >1
        for i=1:obs_per_row -1
            for r=1:rows
                
                base_point_x =  row_obs(1,1,i,r);
                base_point_y = (row_obs(1,2,i+1,r) + row_obs(1,2,i,r))/2;
                
                base_point_x = base_point_x + h_shift;
                
                figure(2);
                hold on;
                plot(base_point_x, base_point_y, 'or', 'MarkerSize', 5);
                hold on;
                
                extra_row_obs(1,1,i,r) = base_point_x;
                extra_row_obs(1,2,i,r) = base_point_y + 0.5 * v_length;
                
                extra_row_obs(2,1,i,r) = base_point_x + h_length ;
                extra_row_obs(2,2,i,r) = base_point_y + 0.5 * v_length;
                
                extra_row_obs(3,1,i,r) = base_point_x + h_length ;
                extra_row_obs(3,2,i,r) = base_point_y - 0.5 * v_length;
                
                extra_row_obs(4,1,i,r) = base_point_x;
                extra_row_obs(4,2,i,r) = base_point_y - 0.5 * v_length;
                
                extra_row_obs(5,1,i,r) = base_point_x;
                extra_row_obs(5,2,i,r) = base_point_y + 0.5 * v_length;
                
            end
            
            figure(2);
            line(extra_row_obs(:,1,i,r), extra_row_obs(:,2,i,r));
            hold on;
            
        end
    end
    
    fprintf(1, 'export geometry \n');
    savefile = [outputdir, 'extra_obstacles.mat'];
    save(savefile, 'extra_row_obs');
    clear('extra_row_obs');
    
    
    clear;
    
    fprintf(1, '\n=== done ===\n\n');
    
end



%%%%%
% d    = 10 mu
% Ly   =  2 mm
% Lx   =  10 mm / 4 obstacle rows
% fill = 0.01
% N    =2000
% 10 min