close all hidden;
%clear all;

%outputdir  = 'd_sim/setup_002_opt_mu05/';
%outputdir  = 'd_sim/setup_001_exp_mu05/';

%outputdir  = 'd_sim/setup_010_d050/';
%inputdir   = 'd_geom/setup_010_d050/';

%outputdir  = 'd_sim/mu01v10/setup_010_d020/';
%inputdir   = 'd_geom/setup_010_d020/';

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% re-import geometry
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fprintf(1, 'TEST: re-import geometry \n');
loadfile = [inputdir, 'obstacles.mat'];
load(loadfile, 'row_obs');


[opoints,odim,obs_per_row,rows] = size(row_obs);

loadfile = [inputdir, 'boundary.mat'];
load(loadfile, 'corn');

[corners,cdim]= size(corn);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% plot
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close(figure(1));
figure(1);

line(corn(:,1), corn(:,2))


for r=1:rows
    for i=1:obs_per_row
        line(row_obs(:,1,i,r), row_obs(:,2,i,r))
    end
end

%axis xy;
%axis tight;
%axis image
%axis equal;
hold on;

axis image;
xlabel('X (bodylength)');
ylabel('Y (bodylength)');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% plot INITIAL configuration
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

loadfile = [outputdir, 'sys_evol.mat'];
load(loadfile, 'sys_evol');


MyMarkerSize =2;
plot(sys_evol(:,3,1), sys_evol(:,4,1), 'rs', 'Marker', 'o', 'MarkerSize', MyMarkerSize);   


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% plot FINAL configuration
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close(figure(2));
figure(2);

line(corn(:,1), corn(:,2))


for r=1:rows
    for i=1:obs_per_row
        line(row_obs(:,1,i,r), row_obs(:,2,i,r))
    end
end

%axis xy;
%axis tight;
%axis image
%axis equal;
hold on;

axis image;
xlabel('X (bodylength)');
ylabel('Y (bodylength)');


plot(sys_evol(:,3,10), sys_evol(:,4,10), 'rs', 'Marker', 'o', 'MarkerSize', MyMarkerSize);   


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% plot histograms
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure(3);
scatterhist(sys_evol(:,5,10), sys_evol(:,6,10));
xlabel('V_x (bodylength / sec)');
ylabel('V_y (bodylength / sec)');


close(figure(5));
figure(5)
hist(sys_evol(:,3,1),rows+1);
xlabel('X (bodylength)');
title('initial')

close(figure(6));
figure(6)
hist(sys_evol(:,3,10),rows+1);
xlabel('X (bodylength)');
title('final')
