close all hidden;


w_angle_deg =38;
w_gap = 3;
output =  30;

w_inputdir  = ['d_geom/setup','_a', num2str(w_angle_deg),'_g', num2str(w_gap),'/'];
w_outputdir  = ['d_sim/setup','_a', num2str(w_angle_deg),'_g', num2str(w_gap),'/'];
       
inputdir  = w_inputdir;
outputdir = w_outputdir;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% re-import geometry with extra obstacles
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fprintf(1, 'TEST: re-import geometry \n');
loadfile = [inputdir, 'obstacles.mat'];
load(loadfile, 'row_obs');
[opoints,odim,obs_per_row,rows] = size(row_obs);

 e_rows=0;
% loadfile = [inputdir, 'extra_obstacles.mat'];
% load(loadfile, 'extra_row_obs');
% [e_opoints, e_odim, e_obs_per_row, e_rows] = size(extra_row_obs);


loadfile = [inputdir, 'boundary.mat'];
load(loadfile, 'corn');
[corners, cdim] = size(corn);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% plot
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close(figure(1));
figure(1);

line(corn(:,1), corn(:,2))


for r=1:rows
    for i=1:obs_per_row
        line(row_obs(:,1,i,r), row_obs(:,2,i,r))
    end
end

for r=1:e_rows
    for i=1:e_obs_per_row
        line(extra_row_obs(:,1,i,r), extra_row_obs(:,2,i,r))
        hold on;
    end
end

%axis xy;
%axis tight;
%axis image
%axis equal;
hold on;

axis image;
xlabel('X (bodylength)');
ylabel('Y (bodylength)');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% plot INITIAL configuration
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

loadfile = [outputdir, 'sys_evol.mat'];
load(loadfile, 'sys_evol');


MyMarkerSize =2;
plot(sys_evol(:,3,1), sys_evol(:,4,1), 'rs', 'Marker', 'o', 'MarkerSize', MyMarkerSize);   
title('initial');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% plot FINAL configuration
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close(figure(2));
figure(2);

line(corn(:,1), corn(:,2));


for r=1:rows
    for i=1:obs_per_row
        line(row_obs(:,1,i,r), row_obs(:,2,i,r))
    end
end

for r=1:e_rows
    for i=1:e_obs_per_row
        line(extra_row_obs(:,1,i,r), extra_row_obs(:,2,i,r))
        hold on;
    end
end

%axis xy;
%axis tight;
%axis image
%axis equal;
hold on;

axis image;
xlabel('X (bodylength)');
ylabel('Y (bodylength)');
title('final');

plot(sys_evol(:,3,output), sys_evol(:,4,output), 'rs', 'Marker', 'o', 'MarkerSize', MyMarkerSize);   


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% plot histograms
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure(3);
scatterhist(sys_evol(:,5,output), sys_evol(:,6,output));
xlabel('V_x (bodylength / sec)');
ylabel('V_y (bodylength / sec)');
title('final');


close(figure(5));
figure(5)
hist(sys_evol(:,3,1), rows+1);
xlabel('X (bodylength)');
title('initial')

close(figure(6));
figure(6)
hist(sys_evol(:,3,output), rows+1);
xlabel('X (bodylength)');
title('final')
