%%%%%%%%%%%%%%%%%%%%%%
clear all;
close all;


for w_angle_deg = [20, 28, 38, 48, 58]
    
    d = 1; %diameter = 10 microns
    
    w_obstacle_rows     = 3;
    w_length_y          = 200 * d;
    w_length_x          = (1 + w_obstacle_rows) * w_length_y / 2;
    
    
    
    if w_angle_deg == 20
        w_arm = 8.4 * d; %diameter = 10 microns
    end
    
    if w_angle_deg == 28
        w_arm = 7.6 * d; %diameter = 10 microns
    end
    
    if w_angle_deg == 38
        w_arm = 6.7 * d;
    end
    
    if w_angle_deg == 48
        w_arm = 6.1 * d;
    end
    
    if w_angle_deg == 58 || 68
        w_arm = 5.6 * d;
    end
    
    for w_gap = [2, 3, 4, 5]
        
        fprintf(1,'\n angle = %4.1f [deg]\t arm =%4.1f [d]\t gap =%4.1f [d]', w_angle_deg, w_arm, w_gap);
        
        w_outputdir = ['d_geom/setup','_a', num2str(w_angle_deg),'_g', num2str(w_gap),'/'];
        w_inputdir  =  w_outputdir;
        mkdir(w_outputdir);
        
        
        w_angle = w_angle_deg/180*pi;
        w_shift = 2 * w_arm * sin(w_angle) + d + w_gap;
        
        w_obstacles_per_row = round( w_length_y  / w_shift );
        
        m_geometry;
        
    end
    
    fprintf(1,'\n');
    
    
end