close all hidden;
clear all;

MyMarkerSize =10;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

final_rec = zeros(4,5); %(gaps, angles)


    
for w_angle_deg = [20,28,38,48,58]
    %for w_angle_deg = [37]
    
    if w_angle_deg ==20
        MyMarkerColor ='y';
        angle_index=1;
    end
    if w_angle_deg ==28
        MyMarkerColor ='b';
        angle_index=2;
    end
    if w_angle_deg ==38
        MyMarkerColor ='r';
        angle_index=3;
    end
    if w_angle_deg ==48
        MyMarkerColor ='g';
        angle_index=4;
    end
    if w_angle_deg ==58
        MyMarkerColor ='k';
        angle_index=5;
    end
    
    
    for w_gap = [2,3,4,5]
        %for w_gap = [5]
        
        if w_gap ==2
            MyMarkerSymbol = 'o';
            gap_index =1;
        end
        if w_gap ==3
            MyMarkerSymbol = 'v';
            gap_index =2;
        end
        if w_gap ==4
            MyMarkerSymbol = '^';
            gap_index =3;
        end
        if w_gap ==5
            MyMarkerSymbol = 's';
            gap_index =4;
        end
        
        fprintf(1,'\n angle = %4.1f [deg]\t gap =%4.1f [d]\n', w_angle_deg, w_gap);
        
        w_inputdir_evol  = ['d_sim/setup','_a', num2str(w_angle_deg),'_g', num2str(w_gap),'/'];
        w_inputdir_geom  = ['d_geom/setup','_a', num2str(w_angle_deg),'_g', num2str(w_gap),'/'];
        
        w_outputdir =  ['d_sim/'];
        
        
        
        % load particle data
        fprintf(1, 'import geometry data\n');
        loadfile = [w_inputdir_geom, 'obstacles.mat'];
        load(loadfile, 'row_obs');
        
        [opoints,odim,obs_per_row,rows] = size(row_obs);
        
        % load particle data
        loadfile = [w_inputdir_evol, 'sys_evol.mat'];
        load(loadfile, 'sys_evol');
        
        [particles, particleinfo, maxtime ]=size(sys_evol);
        
        [count, boxpos] = hist(sys_evol(:,3,maxtime),5);
        
        w_angle = w_angle_deg*pi/180;
        gap   = (1 + row_obs(6,2,2,1) - row_obs(2,2,1,1) )
        ratio = count(rows+1)/count(1);
        
        
        MyMarkerStyle =[MyMarkerSymbol,MyMarkerColor];
        
        
        % rectification ratio over time
        
        figure(1);
        for t=1:maxtime
            [count, boxpos] = hist(sys_evol(:,3,t),5);
            
            count1(angle_index, gap_index ,t) = count(1);
            
            %plot(t,ratio(angle_index, gap_index,t), MyMarkerStyle, 'MarkerSize', MyMarkerSize/2);
            plot(t,count1(angle_index, gap_index,t), MyMarkerStyle, 'MarkerSize', MyMarkerSize/2);
            hold on;
        end
        
        figure(2);
        for t=1:maxtime
            [count, boxpos] = hist(sys_evol(:,3,t),5);
            
            count2(angle_index, gap_index ,t) = count(2);
            
            %plot(t,ratio(angle_index, gap_index,t), MyMarkerStyle, 'MarkerSize', MyMarkerSize/2);
            plot(t,count2(angle_index, gap_index,t), MyMarkerStyle, 'MarkerSize', MyMarkerSize/2);
            hold on;
        end
        
        
        figure(3);
        for t=1:maxtime
            [count, boxpos] = hist(sys_evol(:,3,t),5);
            
            count3(angle_index, gap_index ,t) = count(3);
            
            %plot(t,ratio(angle_index, gap_index,t), MyMarkerStyle, 'MarkerSize', MyMarkerSize/2);
            plot(t,count3(angle_index, gap_index,t), MyMarkerStyle, 'MarkerSize', MyMarkerSize/2);
            hold on;
        end
        
        figure(4);
        for t=1:maxtime
            [count, boxpos] = hist(sys_evol(:,3,t),5);
            
            ratio(angle_index, gap_index ,t) = count(rows+1)/count(1);
            count4(angle_index, gap_index ,t) = count(rows+1);
            
            %plot(t,ratio(angle_index, gap_index,t), MyMarkerStyle, 'MarkerSize', MyMarkerSize/2);
            plot(t,count4(angle_index, gap_index,t), MyMarkerStyle, 'MarkerSize', MyMarkerSize/2);
            hold on;
        end
        
        
        
        % final rectification
        
        final_rec(gap_index, angle_index) = mean(count4(angle_index, gap_index, round(0.4*maxtime):1:maxtime))/mean(count1(angle_index, gap_index, round(0.5*maxtime):1:maxtime))
        
        figure(5);
        plot(gap,  final_rec(gap_index, angle_index) , MyMarkerStyle, 'MarkerSize', MyMarkerSize)
        hold on;
        
    end
    
end

savefile = 'final_rectif.mat';
save(savefile, 'final_rec' );

figure(1);
xlabel('time (outputs)');
ylabel('population  N_1');
xlim([0,maxtime]);
%ylim([0,20]);

figure(2);
xlabel('time (outputs)');
ylabel('population  N_2');
xlim([0,maxtime]);

figure(3);
xlabel('time (outputs)');
ylabel('population  N_3');
xlim([0,maxtime]);

figure(4);
xlabel('time (outputs)');
ylabel('population  N_3');
xlim([0,maxtime]);

figure(5);
xlabel('gap (body diamater d)');
ylabel('rectification ratio  <N_4> / <N_1>');
xlim([1.5,5.5]);
yscale=2;
ylim([0,10/yscale]);

text(3.5, 5/yscale, 'yellow:   20 deg');
text(3.5, 6/yscale, 'blue:   28 deg');
text(3.5, 7/yscale, 'red:     38 deg');
text(3.5, 8/yscale, 'green:    48 deg');
text(3.5, 9/yscale, 'black:   58 deg');




% legend
% unfilled = 1h
% filled   = 6 h


%plot(2.5, 55, 'ok');
%text(2.7, 55, 'V=10 d/s');

%plot(2.5, 52, 'sk');
%text(2.7, 52, 'V=6  d/s');


saveas( figure(1), 'fig_pop_N01.pdf' );

saveas( figure(1), 'fig_pop_N01.pdf' );
saveas( figure(2), 'fig_pop_N02.pdf' );
saveas( figure(3), 'fig_pop_N03.pdf' );
saveas( figure(4), 'fig_pop_N04.pdf' );
saveas( figure(5), 'fig_rec_ratio.pdf' );


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%geom_setup = 'setup_010_d040/';
%data_set ='mu01v04_long/';
%inputdir_evol   = ['d_sim/', data_set, geom_setup]

%loadfile = [inputdir_evol, 'sys_evol.mat'];
%load(loadfile, 'sys_evol');


% for t=1:100
%     [count, boxpos] = hist(sys_evol(:,3,t),5);
%     figure(2);
% %     plot(t,count(1,5)/count(1,4), 'ok', 'MarkerSize', 5);
% %     hold on;
% %     plot(t,count(1,4)/count(1,3) , '^k', 'MarkerSize', 5);
% %     hold on;
% %     plot(t,count(1,3)/count(1,2) , 'vk', 'MarkerSize', 5);
% %     hold on;
% %     plot(t,count(1,2)/count(1,1) , 'sk', 'MarkerSize', 5);
% %     hold on;
%     plot(t,count(1,5)/count(1,1) , 'sk', 'MarkerSize', 5);
%     hold on;
% end
