% This script creates a new flow field
% We need to initialize U1, U2, U3, TH and P

% Since we are starting with a new flow, set TIME_STEP=0
% If you are continuing an existing simulation, don't do this (unless you want to reset the timestep)
TIME_STEP=0;

U1=zeros(NX,NY); % U1 is the velocity in the X direction
U2=zeros(NX,NY); % U2 is the velocity in the Y direction
U3=zeros(NX,NY); % U3 is the velocity in the Z direction
P=zeros(NX,NY); % P is the pressure
PHI=zeros(NX,NY); % PHI is a temporary variable used to make the velocity divergence free

TH=zeros(NX,NY,N_TH);

% ********* User Input ********

% Initial density profile
for j=1:NY
  if (GYF(j)<-50)
    TH(ii,j,1)=N2*GYF(j);
  else
    TH(ii,j,1)=N2*-50;
  end
end

% Initial values for biogeochemical variables
for j=1:NY
  if (GYF(j)>-50)
    TH(:,j,2)=0.2;
    TH(:,j,3)=0.1;
    TH(:,j,4)=0.1;
    TH(:,j,5)=0.0;
  else
    TH(:,j,2)=0.0;
    TH(:,j,3)=0.0;
    TH(:,j,4)=0.0;
    TH(:,j,5)=0;
  end
end

% Load saved fields from file
load TH_save.mat;
init_iron;

detritus_init=squeeze(sum(TH(:,2,5),1)*LX*DYF(1));

% Add a random perturbation to the velocity
 U1=U1+0.00001*(rand(NX,NY)-0.5);
 U2=U2+0.00001*(rand(NX,NY)-0.5);

% ********* End of User input *********

% Make sure that the new flow field satisfies the boundary conditions
rk_apply_bc_vel

