% This script is called every N_DISP_FLOW timesteps, and writes something to the screen

n_display=floor((TIME_STEP-1)/N_DISP_FLOW)+1; % Calculate the index for making a movie file
clf;

% ******** User Input *********

% Calculate and save the bottom detritus field
result(n_display)=squeeze(sum(TH(:,2,5),1)*LX*DYF(1))-detritus_init;
TIME_display(n_display)=TIME;

% Change the following lines to plot whatever you like during the simulation
for n=2:6
subplot(2,3,n-1)
surf(GXF(ii),GYF(jj),zeros(length(ii),length(jj))',TH(ii,jj,n)','EdgeColor','none'),view(0,90); shading interp; 
set(gca,'FontName','Times','FontSize',14);
xlabel('x (m)');
ylabel('depth (m)');
caxis auto
%caxis([0 0.2]);
shading interp
axis([0 LX GYF(jj(1)) GYF(jj(end))]);
colorbar
end
subplot(2,3,1); title('Nutrient');
subplot(2,3,2); title('Phytoplankton');
subplot(2,3,3); title('Zooplankton');
subplot(2,3,4); title('Detritus');
subplot(2,3,5); title('Iron');

subplot(2,3,6);
plot(TIME_display/3600/24,result(1:end),'-');
xlabel('Time (days)'); ylabel('Detritus at seafloor');


% ******** End of User Input *********

% pause for a short amount of time to make sure that there is enough time for the screen to refresh
pause(0.01);



