% Use this script to add user-defined terms to the RHS
% of the momentum and scalar equations.
% Momentum forcing should be added to F1, F2, F3
% Scalar sources/sinks should be added to FTH

% ****** Biogeochemical model *****
% This section adds term for an NPZD model based on Whitt et al.
% Here, the following assignments are used:
% TH(:,:,2): Nutrients
% TH(:,:,3): Phytoplankton
% TH(:,:,4): Zooplankton
% TH(:,:,5): Detritus
% TH(:,:,6): Iron

% Set various parameters (See Table 2 in Whitt et al)
% Time units
tau=3600*24;

kw=0.055;
alpha=0.1/3600/24;
I0=50;
Vm=1.5/tau;
kN=0.8;
sigma_d=0.04/tau;
Lambda=0.5;
R=0.9/tau;
gamma_N=0.3;
zeta=0.04/tau;
zeta_hat=0.28/tau;
wd=-0.25/tau*ones(NX,NY); wd(:,NY-1:NY)=0; wd(:,1:2)=0;
wi=-0.25/tau*ones(NX,NY); wi(:,NY-1:NY)=0; wi(:,1:2)=0;
N80=2.5;
beta_N=0.02/tau;

% Define functions
for j=jj
I(j)=I0*exp(kw*GYF(j));
U(ii,j)=Vm*TH(ii,j,2)./(kN+TH(ii,j,2))*alpha*I(j)/sqrt(Vm^2+alpha^2*I(j)^2) ...
  .*(1+min(TH(ii,j,6),0.4)).^2;
%delta(ii,j)=0.1/tau*(1+tanh((GYF(j)+50)/10))/2;
delta(ii,j)=0.1/tau;
end
G(ii,jj)=R*(1-exp(-Lambda*TH(ii,jj,3)));
delta(ii,jj(1:2))=0;

% Nutrients:
FTH(ii,jj,2)=FTH(ii,jj,2)-U(ii,jj).*TH(ii,jj,3)+gamma_N*G(ii,jj).*TH(ii,jj,4)+delta(ii,jj).*TH(ii,jj,5)-beta_N*(TH(ii,jj,2)-N80);
% Phytplankton
FTH(ii,jj,3)=FTH(ii,jj,3)+U(ii,jj).*TH(ii,jj,3)-sigma_d*TH(ii,jj,3)-G(ii,jj).*TH(ii,jj,4);
% Zooplankton
FTH(ii,jj,4)=FTH(ii,jj,4)+(1-gamma_N)*G(ii,jj).*TH(ii,jj,4)-zeta*TH(ii,jj,4)-zeta_hat*TH(ii,jj,4).^2;
% Detritus
FTH(ii,jj,5)=FTH(ii,jj,5)+sigma_d*TH(ii,jj,3)+zeta*TH(ii,jj,4)+zeta_hat*TH(ii,jj,4).^2-delta(ii,jj).*TH(ii,jj,5);
% sinking term
FTH(ii,jj,5)=FTH(ii,jj,5)-(wd(ii,jp).*TH(ii,jp,5)-wd(ii,jj).*TH(ii,jj,5))./DYF(ii,jj);
% Iron
FTH(ii,jj,6)=FTH(ii,jj,6)-(wi(ii,jp).*TH(ii,jp,6)-wi(ii,jj).*TH(ii,jj,6))./DYF(ii,jj);


