% Setup parameters

H=2000;
nz=2000;

% How often to save variables (in timesteps)
nsave=100;

% Physical parameters
beta=1;
epsilon=1/50;

% Create grid
z(2:nz+1)=linspace(0,H,nz);
dz=z(3)-z(2);
z(1)=z(2)-dz;
z(nz+2)=z(nz+1)+dz;

tend=1e5;
dt=0.5;

k=1;
% Set ics
gi=0.0218;
ei=0.0994;
g=gi*(1-cosh(20*(z/H-1/2))/cosh(10));
e(1:nz+2)=ei;

k=2;
t=0;
save_count=0;
while t<tend

% Calculate mixing length
    l=sqrt(e)./sqrt(e+g);

% a useful intermediate variable
    le=l.*sqrt(e);
    
% Calculate RHS arrays    
    rhs_g=ddz2(l.*sqrt(e).*g,nz,dz);
    rhs_e=beta*ddz(le,nz,dz).*ddz(e,nz,dz)+beta*le(2:nz+1).*ddz2(e,nz,dz)-le(2:nz+1).*g(2:nz+1)+epsilon*(1-e(2:nz+1)).*(e(2:nz+1).^0.5)./l(2:nz+1);
    
% Timestep
    g(2:nz+1)=g(2:nz+1)+dt*rhs_g;
    e(2:nz+1)=e(2:nz+1)+dt*rhs_e;
    
% Apply BCs to updated solution
    e(nz+2)=e(nz+1);
    e(1)=e(2);
    g(nz+2)=0;
    g(1)=0;
   
% Save arrays every nsave timesteps
     if (mod(k,nsave)==0)
         disp(['Time ' num2str(t)])        
         save_count=save_count+1;
         t_save(save_count)=t;
         g_save(1:nz,save_count)=g(2:nz+1);
         e_save(1:nz,save_count)=e(2:nz+1);
         z_save(1:nz)=z(2:nz+1);
%    plotyy(z(2:nz+1),g(2:nz+1),z(2:nz+1),e(2:nz+1));
        subplot(1,4,1), plot(g,z); ylabel('z'); xlabel('b_z');
        subplot(1,4,2), plot(e,z); xlabel('e');
        subplot(1,4,3), plot(l,z); xlabel('l');
        subplot(1,4,4), plot(g.*l.*sqrt(e),z); xlabel('Buoyancy flux');
%        plot(e./g,z)
    pause(0.01)
     end
     
% Update time and counter arrays    
    k=k+1;
    t=t+dt;
    
    
end

subplot(2,1,1), surf(t_save,z_save,g_save,'EdgeColor','none'),view(0,90); title('b_z'); xlabel('t'); ylabel('z');
subplot(2,1,2), surf(t_save,z_save,e_save,'EdgeColor','none'),view(0,90); title('e'); xlabel('t'); ylabel('z');


    

