% Integrates an NPZ model specified in NPZ_fun.
% This script is just a wrapper.  Various parameters are set inside NPZ_fun

% Define the time interval to consider
tstart=1; tend=90; % 90 days

var0=[1 1e-3 1e-3]; % Set the initial conditions for N, P, and Z

% Solve the governing equations using the matlab ODE solver
[t,var]=ode45(@NPZ_fun,[tstart tend],var0);

N=var(:,1);
P=var(:,2);
Z=var(:,3);

% Plot the results
plot(t,N,'b-','LineWidth',2); hold on;
plot(t,P,'g-','LineWidth',2);
plot(t,Z,'r-','LineWidth',2);
legend('N','P','Z');
set(gca,'FontName','Times','FontSize',14);
xlabel('Time (days)');


