function dvardt = NPZ_fun(t,var)

% Model parameters
Ns=0.5; % Nutrient half-saturation value
r=2; % Phytoplankton respiration rate
beta=0.5; % Zooplankton grazing efficiency
alpha=1; % Zooplankton grazing rate
mu=10;  %Phytoplankton growth rate (can be constant or a function of t)
%mu=10-9*cos(mod(t,365)*2*pi/365);
m=0.1; % Zooplankton mortality rate

dvardt = [-mu*var(2)*var(1)/(var(1)+Ns)+r*var(2);
           mu*var(2)*var(1)/(var(1)+Ns)-alpha*var(2)*var(3)-r*var(2);
           alpha*beta*var(2)*var(3)-m*var(3)];

end

